package com.qboxus.tictic.activitesfragments.livestreaming.activities

import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.databinding.DataBindingUtil
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.shoping.SelectProductA
import com.qboxus.tictic.activitesfragments.shoping.models.ProductModel
import com.qboxus.tictic.databinding.ActivityConcertSelectionBinding
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import io.agora.rtc2.Constants

class ConcertSelectionA : BaseActivity() {

    lateinit var binding:ActivityConcertSelectionBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Functions.setLocale(
            Functions.getSharedPreference(this)
                .getString(Variables.APP_LANGUAGE_CODE, Variables.DEFAULT_LANGUAGE_CODE),
            this,
            javaClass,
            false
        )
        binding=DataBindingUtil.setContentView(this,R.layout.activity_concert_selection)

        initControl()
        actionControl()
    }

    private fun actionControl() {
        binding!!.ivBack!!.setOnClickListener { super@ConcertSelectionA.onBackPressed() }
        binding!!.ivSetting!!.setOnClickListener { onSettingClicked() }
        binding!!.tabMinus!!.setOnClickListener {
            if (!TextUtils.isEmpty(binding!!.etVorzCoins!!.text.toString())) {
                substractNumber(binding!!.etVorzCoins!!.text.toString())
            }
        }
        binding!!.tabAdd!!.setOnClickListener {
            if (!TextUtils.isEmpty(binding!!.etVorzCoins!!.text.toString())) {
                if (!TextUtils.isEmpty(binding!!.etVorzCoins!!.text.toString())) {
                    addNumber(binding!!.etVorzCoins!!.text.toString())
                }
            }
        }
        binding!!.tabStartLive!!.setOnClickListener { gotoRoleActivity() }

        binding!!.addProductBtn!!.setOnClickListener {
            val intent = Intent(this@ConcertSelectionA, SelectProductA::class.java)
            intent.putExtra("isMultiple", true)
            resultCallback.launch(intent)
        }
    }

    var selectList: ArrayList<ProductModel>? = ArrayList()
    var resultCallback = registerForActivityResult<Intent, ActivityResult>(
        ActivityResultContracts.StartActivityForResult()
    ) { result ->
        if (result.resultCode == RESULT_OK) {
            val data = result.data
            selectList = data!!.getSerializableExtra("data") as ArrayList<ProductModel>?
            binding!!.productBtnTxt!!.text = selectList!!.size.toString() + " Products Selected"
        }
    }

    private fun substractNumber(numberStr: String) {
        var number = Integer.valueOf(numberStr)
        if (number > 0) {
            number = number - 1
        }
        binding!!.etVorzCoins!!.setText("" + number)
    }

    private fun addNumber(numberStr: String) {
        var number = Integer.valueOf(numberStr)
        if (number < 1000) {
            number = number + 1
        }
        binding!!.etVorzCoins!!.setText("" + number)
    }

    fun onSettingClicked() {
        val i = Intent(this, SettingsActivity::class.java)
        startActivity(i)
    }

    private fun initControl() {
        setUpScreenData()
    }

    var userId: String? = null
    var userName: String? = null
    var userPic: String? = null
    var streamingId: String? = null
    var userRole = 0
    private fun setUpScreenData() {
        val bundle = intent
        if (bundle != null) {
            userId = bundle.getStringExtra("userId")
            userName = bundle.getStringExtra("userName")
            userPic = bundle.getStringExtra("userPicture")
            userRole = bundle.getIntExtra("userRole", Constants.CLIENT_ROLE_BROADCASTER)
            streamingId = bundle.getStringExtra("streamingId")
        }
        binding!!.tvUserName!!.text = userName
    }

    // open  the live streaming of othe user or open userself
    fun gotoRoleActivity() {
        val intent = Intent()
        intent.putExtra("userId", userId)
        intent.putExtra("userName", userName)
        intent.putExtra("userPicture", userPic)
        intent.putExtra("userRole", userRole)
        intent.putExtra("description", "" + binding!!.etDescription!!.text.toString())
        intent.putExtra("secureCode", "")
        intent.putExtra("streamingId", streamingId)
        intent.putExtra("joinStreamPrice", Integer.valueOf("" + binding!!.etVorzCoins!!.text.toString()))
        intent.putExtra(
            com.qboxus.tictic.activitesfragments.livestreaming.Constants.KEY_CLIENT_ROLE,
            userRole
        )
        intent.putExtra("productList", selectList)
        config().uid = Functions.getSharedPreference(this)
            .getString(Variables.U_ID, "")
        config().channelName = streamingId
        if (binding!!.rbPrivate!!.isChecked) {
            intent.putExtra("onlineType", "oneTwoOne")
            intent.setClass(this@ConcertSelectionA, SingleCastStreamer::class.java)
        } else {
            intent.putExtra("dualStreaming", binding!!.rbPublic!!.isChecked)
            intent.putExtra("onlineType", "multicast")
            intent.setClass(this@ConcertSelectionA, MulticastStreamerActivity::class.java)
        }
        startActivity(intent)
        finish()
    }
}